require 'sketchup.rb'
class Dimensions < Sketchup::SelectionObserver 
  def initialize()
    @usedObserver = false   
  end

  def onSelectionBulkChange(selection)
    get_dimensions(selection)
  end

  def get_selection_dimensions
    get_dimensions(Sketchup.active_model.selection)
  end

  def get_dimensions(selection) 
    boundingBox = selection[0].bounds
    dims = [ boundingBox.height,
    boundingBox.width,
    boundingBox.depth ]
    Sketchup::set_status_text(("width X: " + dims[1].to_s + ". length(depth) Y: " + dims[0].to_s + ". height Z: " + dims[2].to_s ), SB_PROMPT)
  end

  def connect_observer  
    if(@usedObserver) then
      return remove_observer
    else   
      return add_observer   
    end
  end

  def add_observer
    @usedObserver = true  
    Sketchup.active_model.selection.add_observer self 
    return MF_CHECKED
  end

  def remove_observer
    @usedObserver = false  
    Sketchup.active_model.selection.remove_observer self
    return MF_UNCHECKED
  end

  def menu_checked
    if(@usedObserver) then
      return MF_CHECKED
    else   
      return MF_UNCHECKED   
    end  
  end
end

file_loaded("GetDimensions.rb")